//	ProFileTypes.h

#ifndef _H_ProFileTypes
#define	_H_ProFileTypes

#include "ByteMunger.h"

typedef	char	Pro_FileTypeStr[4];
typedef char	Pro_FileDescStr[128];

#ifndef ushort
	typedef unsigned short ushort;
	typedef unsigned long ulong;
#endif

typedef struct {
	ushort				fileType;
	ushort				auxType;
	Pro_FileDescStr		descStr;
} Pro_FileTypeRec;

typedef struct {
	RboShort		version;
	RboShort		flags;
	RboShort		numEntries;
	RboShort		spareWord;
	RboShort		indexRecordSize;
	RboShort		offsetToIndex;
} Pro_FTypesHeader;

typedef struct {
	RboShort	fileType;
	Rbo4Byte	auxType;
	RboShort	flags;
	RboShort	offsetToEntry;
} Pro_FTypeEntry;

Boolean		Pro_InitFileTypes(void);
Boolean		Pro_GetFileType(Pro_FileTypeRec *typeRec);
MenuRef		Pro_BuildFileTypeMenu(void);
void		Pro_MenuItemToFileAndAux(MenuHandle theMenu, short menuItem, short *fileType, ushort *auxType);
short		Pro_FileTypeToIndex(Byte fileType, ushort auxType);

#endif